# Remove most uncompatible GPUs from the list
function ApplyFilter([array]$pciDevicesList){
    $filteredDevices = @()

    foreach ($pciDevice in $pciDevicesList) {
        if (($pciDevice.DeviceName -notmatch "Mobile") -and
            ($pciDevice.DeviceName -notmatch "Laptop") -and
            ($pciDevice.DeviceName -notmatch "Max-Q") -and
            ($pciDevice.DeviceName -notmatch "Sample"))
        {
            if ($pciDevice.DeviceName -match "RTX") {
                # Add the device to the filtered list if it contains "RTX"
                $filteredDevices += $pciDevice
            }
            elseif ($pciDevice.DeviceName -match "GTX") {
                # Extract the model number from the DeviceName if it contains "GTX" and if it is semi-recent, add it to the filtered list
                $modelNumber = [regex]::Match($pciDevice.DeviceName, '(?<=GTX\s)\d+').Value

                if ($modelNumber -like "9*" -or $modelNumber -like "1*") {
                    # Add the device to the filtered list if the model number is from the 9xx or 1xxx series
                    $filteredDevices += $pciDevice
                }
            }
        }
    }

    return $filteredDevices
}

function Get-GpuList([string]$vendorId)
{
    $url = "https://devicehunt.com/search/type/pci/vendor/$vendorId/device/any"
    
    $webContent = Invoke-WebRequest -Uri $url -UseBasicParsing

    # Define the regex pattern to match Device IDs and Device Names
    $pattern = '<td\s+class=\''\''><a\s+href="\/view\/type\/pci\/vendor\/10DE\/device\/\w+"\s+class="\+text-uppercase">\s*(\w+)\s*<\/a><\/td>\s*<td>\s*([^<]+)\s*<\/td>'

    # Run the regex to find all matches
    $matches = [regex]::Matches($webContent.Content, $pattern)

    # Create an array to hold the results
    $results = @()
    # Loop through the matches and extract Device ID and Device Name
    foreach ($match in $matches) {
        $deviceID = $match.Groups[1].Value.ToUpper()
        $deviceName = $match.Groups[2].Value
        $results += [PSCustomObject]@{
            DeviceID = $deviceID
            DeviceName = $deviceName
        }
    }

    $results = ApplyFilter -pciDevicesList $results

    return $results
}

$compatibleGpus = @{
    "10DE" = @()
    "1002" = @()
    "8086"= @()
}
$compatibleVendorList = @(
    @{
        VendorName = "nvidia"
        VendorId = "10DE"
    }
)

foreach($vendor in $compatibleVendorList) 
{
    $gpuList = Get-GpuList -vendorId $vendor.VendorId
    foreach($gpu in $gpuList)
    {
        $compatibleGpus[$vendor.VendorId] += $gpu
    }
}

$json = $compatibleGpus | ConvertTo-Json -Depth 4
Write-Host $json
$json | Out-File -FilePath "C:\AOFG\compatibleGPUs.json"
